# Python 3.7  
# AlgExec : version SANS éditeur de texte

from tkinter.font import Font
import tkinter as tk
#import tkinter.messagebox
import tkinter.filedialog
#from tkinter import *
from tkinter.scrolledtext import ScrolledText
import algexec_a as A
import algexec_v1 as V1
import algexec_e as E
import os
import struct

def verif():
    A.ScrolledText_ecran_exec.grid_remove()
    A.ScrolledText_ecran_exec = ScrolledText(A.algexec,font=A.police2)
    A.ScrolledText_ecran_exec.config(state=tk.NORMAL)
    A.ScrolledText_ecran_exec.delete(0.0,tk.END)
    A.ScrolledText_ecran_exec.grid_remove()
    A.Listbox_erreurs.config(state=tk.NORMAL)
    if not A.algo_ouvert:
        A.top.rowconfigure(0, weight=3)            
        A.top.columnconfigure(0, weight=3)         
        A.Listbox_erreurs.grid(sticky=tk.N+tk.S+tk.E+tk.W)
        A.Listbox_erreurs.insert(tk.END,"IL FAUT OUVRIR UN ALGORITHME")
        return None
    V1.verification() # on lance la vérification
    A.Listbox_erreurs.config(state=tk.DISABLED)
    return None

def ouvrir():
    #A.ficalgo_nom = tkinter.filedialog.askopenfilename(title="Choisir un algorithme",filetypes=[("Tous","*.*")])
    A.Listbox_erreurs.delete(0,tk.END)   
    A.ficalgo_nom = tkinter.filedialog.askopenfilename(initialdir = A.dossier_travail,title="Choisir un algorithme",filetypes=[("Algos",('*.alg',"*.ALG")),("Tous","*.*")])
    if A.ficalgo_nom == "" : return None
    A.ScrolledText_ecran_exec = ScrolledText(A.algexec,font=A.police2)
    A.ScrolledText_ecran_exec.config(state=tk.NORMAL)
    A.ScrolledText_ecran_exec.delete(0.0,tk.END)
    A.ScrolledText_ecran_exec.grid_remove()
    A.erreur_grave = False ; A.verif_ok = False
    if A.ficalgo_nom != "":
        #print("enreg  nom fichier = ",ficalgo_nom)
        A.algexec.title("Alg'Exec dossier de travail (" + A.dossier_travail.upper()+ ")    l'algorithme " + A.ficalgo_nom.upper() + " est ouvert")
        A.algo_ouvert = True
        A.liste_erreurs = []
        lecture_algo()
        A.Listbox_erreurs.config(state=tk.DISABLED)
    else:
        A.algexec.title("Alg'Exec le dossier de travail est " + A.dossier_travail.upper())
        A.algo_ouvert = False 
        A.algo = ""

def lecture_algo():
    try:
        A.algo_lignes = open(A.ficalgo_nom,"r")
    except:
        A.liste_erreurs.append("OUVERTURE du fichier     " + A.ficalgo_nom + "     IMPOSSIBLE\n")
        V1.affiche_erreurs()
        return None
    A.Listbox_erreurs.config(state=tk.NORMAL)
    A.algo = A.algo_lignes.read() ; A.algo = A.algo.strip()
    A.algo_lignes.close()
    if A.algo == "":
        A.Listbox_erreurs.insert(tk.END,"L'ALGO EST VIDE")
        return None
    A.Listbox_erreurs.delete(0,tk.END)
    A.t_algo_brut = A.algo.splitlines() # l'algo a été copié dans le tableau t_algo_brut[]
    for __i in range(0,len(A.t_algo_brut)):
        __texte = A.t_algo_brut[__i]
        A.liste_erreurs.append(__texte)
    affiche_erreurs()

def affiche_erreurs():
    A.top.rowconfigure(0, weight=3)            
    A.top.columnconfigure(0, weight=3)         
    A.Listbox_erreurs.delete(0,tk.END)
    A.Listbox_erreurs.grid(sticky=tk.N+tk.S+tk.E+tk.W)
    for __i in range(0,len(A.liste_erreurs)):
        A.Listbox_erreurs.insert(tk.END,A.liste_erreurs[__i])

def dossier_travail():
    __dossier_travail = A.dossier_travail
    __dossier_travail = tkinter.filedialog.askdirectory(initialdir = __dossier_travail,title='Choisissez un dossier de travail')
    if __dossier_travail == "" : return None
    if len(__dossier_travail) > 0:
        os.chdir(__dossier_travail)
        A.dossier_travail = __dossier_travail + '/'
        A.algexec.title("Alg'Exec le dossier de travail est " + A.dossier_travail.upper())

def aide():
    #global ficalgo_nom,algo_sauve
    v_aide = 0
    
def exec():
    A.debog = False ; A.pap = False
    if not A.algo_ouvert:
        A.top.rowconfigure(0, weight=1)            
        A.top.columnconfigure(0, weight=1)         
        A.Listbox_erreurs.config(state=tk.NORMAL)
        A.Listbox_erreurs.insert(0,"IL FAUT OUVRIR UN ALGORITHME")
        A.Listbox_erreurs.grid(sticky=tk.N+tk.S+tk.E+tk.W)
        return None      
    if A.erreur_grave or not A.verif_ok:
        A.top.rowconfigure(0, weight=1)            
        A.top.columnconfigure(0, weight=1)         
        A.Listbox_erreurs.config(state=tk.NORMAL)
        A.Listbox_erreurs.insert(0,"IL FAUT VERIFIER L'ALGORITHME")
        A.Listbox_erreurs.grid(sticky=tk.N+tk.S+tk.E+tk.W)
        return None
    A.Listbox_erreurs.grid_remove()
    exec_suite()
    A.f_pap_tableau.iconify()


def exec_suite(): 
    A.top.rowconfigure(0, weight=1)            
    A.top.columnconfigure(0, weight=1)         
    A.ScrolledText_ecran_exec.grid_remove()
    A.ScrolledText_ecran_exec = ScrolledText(A.algexec, font=A.police2)
    A.ScrolledText_ecran_exec.config(state=tk.NORMAL)
    A.ScrolledText_ecran_exec.delete(0.0,tk.END)
    A.ScrolledText_ecran_exec.config(state=tk.DISABLED)
    A.ScrolledText_ecran_exec.grid(sticky=tk.N+tk.S+tk.E+tk.W)
    A.interruption = A.fin_algo = A.erreur_grave = False
    A.t_instruc_i_suite = 0
    A.t_exec_t = {} # dico contenant les valeurs des tableaux
    A.pile_profon_i = [] ; A.pile_profon_vars = [] ; A.pile_profon_params = [] ; A.pile_profon_i_retour = []
    A.pile_profon = -1 # index de A.pile_profon[]
    
    # pour les fonctions programmées
    A.fonc_prog_i_appel = 0 ; A.fonc_prog_appel = False
    # pour les fichiers
    A.pile_f_i = [] ; A.pile_f_fichier = [] ; A.pile_f_mode_ouverture = [] # "r"=lecture "w"=ecriture "r+b"=lecture_ecriture "a"=extension
    A.pile_f_fichier_ix1 = [] ; A.pile_f_fichier_ix2 = [] ; A.pile_f_clef_ix2_lue = [] ; A.pile_f_clef_ix2_lue_i = [] #fichier indexé
    # pour les bases de données
    A.pile_db = [] ; A.pile_db_curseur = [] ; A.pile_db_nom = [] ; A.pile_db_nom_i = [] ; A.pile_db_erreur_sql = []
    A.pile_db_cursor = [] ; A.pile_db_cursor_ident = [] ; A.pile_db_cursor_var = [] ; A.pile_db_cursor_requete = []
    A.db_num = -1
    E.execution_debut()

def exec_pap():
    if not A.algo_ouvert:
        A.top.rowconfigure(0, weight=1)            
        A.top.columnconfigure(0, weight=1)         
        A.Listbox_erreurs.config(state=tk.NORMAL)
        A.Listbox_erreurs.insert(0,"IL FAUT OUVRIR UN ALGORITHME")
        A.Listbox_erreurs.grid(sticky=tk.N+tk.S+tk.E+tk.W)
        return None      
    if A.erreur_grave or not A.verif_ok:
        A.top.rowconfigure(0, weight=1)            
        A.top.columnconfigure(0, weight=1)         
        A.Listbox_erreurs.config(state=tk.NORMAL)
        A.Listbox_erreurs.insert(0,"IL FAUT VERIFIER L'ALGORITHME")
        A.Listbox_erreurs.grid(sticky=tk.N+tk.S+tk.E+tk.W)
        return None
    A.Listbox_erreurs.grid_remove()
    A.pap = True ; A.suivante = False ; A.debog = False
    pap()
    pap_charge_algo_et_vars()
    exec_suite()

def pap_charge_algo_et_vars():
    for __i in range(0,len(A.t_instruc_code_motcle)):
        A.t_algo_i = A.t_instruc_t_algo_i[__i]
        __texte = A.t_algo_brut[A.t_algo_i] + "\n"
        A.f_pap_algo.insert(tk.END,__texte)
    A.f_pap_algo.grid()
    A.f_pap_vars.insert(tk.END,'{:<20}'.format(A.t_ident[0]) + "Principal")
    for __i in range(1,len(A.t_ident)):
        if A.t_ident_code_motcle == 19:
            __valeur = "Fichier"
        elif A.t_ident_code_motcle == 49:
            __valeur = "Structure"
        elif A.t_ident_code_motcle == 16:
            __valeur = "Enregistrement"
        elif A.t_ident_code_motcle == 34:
            __valeur = "Fonction"
        elif A.t_ident_code_motcle == 42:
            __valeur = "Procedure"
        else:
            if A.t_ident_nb_i[__i] != 0:
                __valeur = "Tableau : Cliquer ici"
            else:
                __valeur = A.t_ident_valeur[__i]
                if __valeur == None:
                    __valeur = "" 
                elif A.t_ident_type[__i] == 0:
                    if __valeur:
                        __valeur = ".faux."
                    else:
                        __valeur = ".vrai."
        A.f_pap_vars.insert(tk.END,'{:<20}'.format(A.t_ident[__i]) + str(__valeur))
    return None

def quitter():
    A.algexec.destroy()

def debut():
    A.algexec = tk.Tk()
    m_principal = tk.Menu()
    m_principal.add_cascade(label="Ouvrir algo",command=ouvrir)
    m_principal.add_cascade(label="Vérification",command=verif)
    m_principal.add_cascade(label="Exécution",command=exec)
    m_principal.add_cascade(label="Exécution pas à pas",command=exec_pap)
    m_principal.add_cascade(label="Dossier de travail",command=dossier_travail)
    m_principal.add_cascade(label="Quitter",command=quitter)
    A.algexec.config(menu=m_principal)

    A.resolution_hauteur = A.algexec.winfo_screenheight()
    A.resolution_largeur = A.algexec.winfo_screenwidth()
    A.resolution_largeur_moitie = str(A.resolution_largeur//2).strip()

    A.algexec_geometry1 = A.resolution_largeur_moitie + "x600" + "-500" + "+50"
    A.algexec_geometry2 = "800x600+100+50"
    A.f_pap_geometry = A.resolution_largeur_moitie + "x600" + "-400" + "+100"
    A.algexec.geometry(A.algexec_geometry1)
    A.top=A.algexec.winfo_toplevel()                


def pap():
    A.f_pap=tk.Toplevel(A.algexec,highlightbackground='white')
    A.algexec.geometry(A.algexec_geometry2)
    A.f_pap.geometry(A.f_pap_geometry)
    A.f_pap.resizable(True,True)
# Pour Menu pas à pas
    A.f_pap_menu = tk.Menu()
    A.f_pap_menu.add_cascade(label="INSTRUCTION SUIVANTE",command=E.pap_instruction_suivante)
    A.f_pap_menu.add_cascade(label="EXECUTION NORMALE",command=E.pap_exe_normale)
    A.f_pap_menu.add_cascade(label="ARRÊT",command=E.pap_arret)
    A.f_pap.config(menu=A.f_pap_menu)
# Pour Affichage de l'algo
    A.top.rowconfigure(0, weight=3)            
    A.top.columnconfigure(0, weight=3)         
    A.f_pap_algo = tk.Listbox(A.f_pap, height=15,width=85,font=A.police2,activestyle='none',selectbackground = 'white',selectforeground = 'black')
    A.f_pap_algo.config(state=tk.NORMAL)
    A.f_pap_algo.grid(sticky=tk.N+tk.S+tk.E+tk.W)
# Pour Affichage des variables et de leur contenu
    A.f_pap_vars = tk.Listbox(A.f_pap, width=85,height=20,font=A.police2,activestyle='none',selectbackground='white',selectforeground = 'black')
    A.f_pap_vars.config(state=tk.NORMAL)
    A.f_pap_vars.bind("<<ListboxSelect>>", E.pap_vars_un_tableau)
    A.f_pap_vars.grid(sticky=tk.N+tk.S+tk.E+tk.W)

def f_pap_tableau_fermeture():
    A.f_pap_tableau.destroy()
#    if tkinter.messagebox.askokcancel("Quitter", "Voulez_vous quitter ?"):
#        A.algexec.destroy()

debut()

#A.algexec.protocol("WM_DELETE_WINDOW", callback)

A.algo_ouvert = False ; A.chaine_variable_long = 60
A.codage_caractere = 'ansi' # les fichiers relatifs et binaires (voir http://sametmax.com/lencoding-en-python-une-bonne-fois-pour-toute/)
# A.codage_caractere = 'utf-8' # les fichiers relatifs et binaires (voir http://sametmax.com/lencoding-en-python-une-bonne-fois-pour-toute/)
A.struct_format_long = [] ; A.struct_format = []
__f = struct.calcsize("=b")
A.struct_format_long.append(__f) ; A.struct_format.append("b") #booleen
__f = struct.calcsize("=c")
A.struct_format_long.append(__f) ; A.struct_format.append("c") #caractere
A.struct_format_long.append(0) ; A.struct_format.append("s") #chaine
__f = struct.calcsize("=d")
A.struct_format_long.append(__f) ; A.struct_format.append("d") #decimal (reel)
__f = struct.calcsize("=h")
A.struct_format_long.append(__f) ; A.struct_format.append("h") #entier court
__f = struct.calcsize("=d")
A.struct_format_long.append(__f) ; A.struct_format.append("d") #reel

A.dossier_travail = os.getcwd()
A.dossier_travail += '/'
os.chdir(A.dossier_travail)
A.algexec.title("Alg'Exec le dossier de travail est " + A.dossier_travail.upper())

A.police2 = Font(family='Courier New',size=11)
A.police1 = Font(family='Arial',size=11)

A.Listbox_erreurs = tk.Listbox(font=A.police1)

A.Message_exec_fin = tk.Message(A.algexec, text = "Terminer (click)")
A.Message_exec_fin.config(aspect=150, width=600, font=('times', 16))

A.Label_ecran_saisie = tk.Label(A.algexec, text="Message")
A.Label_ecran_saisie.config(font=A.police2)

A.Entry_ecran_saisie = tk.Entry(A.algexec)
A.Entry_ecran_saisie.config(font=A.police2,width= A.chaine_variable_long)

A.algexec.mainloop()



