# coding: utf-8
# Bases de données
import sqlite3

from datetime import datetime
import struct
import random
import math
import tkinter as tk
import algexec_a as A
import algexec_e as E

def une_requete_sql():
    A.une_requete_libre_aig = False
    if A.expression.find(":") == 0:
        A.une_requete_libre_aig = True
        A.ident = A.expression[1:len(A.expression)]
        lit_valeur(A.ident)
        A.expression = A.valeur[1:len(A.valeur)-1].strip()
    A.expression_originale = A.expression
    A.expression = A.expression.lower()
    if A.expression.find("start database") == 0:
        sql_start()
        return None

    if A.db_nom not in A.pile_db_nom:
        A.erreur_grave = True ; A.code_erreur = 1080 ; return None #PAS OUVERTE
    A.db_num = A.pile_db_nom.index(A.db_nom)
    A.db_curseur = A.pile_db_curseur[A.db_num]
    A.db = A.pile_db[A.db_num]
    A.pile_db_erreur_sql[A.db_num] = False

    if A.expression.find("create table ") == 0:
        sql_create()
        return None
    if A.expression.find("stop database") == 0:
        sql_stop()
        return None
    if A.expression.find("insert into ") == 0:
        sql_insert()
        return None
    if A.expression.find("commit") == 0:
        try:
            A.db.commit()
        except:
            A.pile_db_erreur_sql[A.db_num] = True
        return None
    if A.expression.find("rollback") == 0:
        try:
            A.db.rollback()
        except:
            A.pile_db_erreur_sql[A.db_num] = True
        return None
    if A.expression.find("select ") == 0:
        sql_select()
        return None
    if A.expression.find("update ") == 0:
        sql_update()
        return None
    if A.expression.find("delete ") == 0:
        sql_update()
        return None
    if A.expression.find("drop table ") == 0:
        try:
            A.db_curseur.execute(A.expression_originale)
        except:
            A.pile_db_erreur_sql[A.db_num] = True
        return None
    if A.expression.find("declare cursor ") == 0:
        sql_curseur_declare()
        return None
    if A.expression.find("open ") == 0:
        sql_curseur_open()
        return None
    if A.expression.find("fetch ") == 0:
        sql_curseur_fetch()
        return None
    if A.expression.find("close ") == 0:
        sql_curseur_close()
        return None
    return None

def sql_start():
    A.pile_db_nom.append(A.db_nom)
    A.pile_db_nom_i.append(A.db_nom_i)
    A.pile_db_erreur_sql.append(False)
    try:
        A.db = sqlite3.connect(A.db_nom + '.db')
        A.pile_db.append(A.db)
        A.db_curseur = A.db.cursor()
        A.pile_db_curseur.append(A.db_curseur)
    except:
        A.pile_db_erreur_sql.append(True)
    return None

def sql_create():
    try:
        A.db_curseur.execute(A.expression)
    except:
        A.pile_db_erreur_sql[A.db_num] = True
    return None

def sql_stop():
    try:
        A.db.close()
    except:
        A.pile_db_erreur_sql[A.db_num] = True
    return None

def sql_insert():
    A.t1 = A.expression.find("values")
    if A.t1 == -1:
        A.erreur_grave = True ; A.code_erreur = 1079 ; return None #requête erronée
    __a = A.expression[A.t1+6:len(A.expression)].strip()
    __a = __a[1:len(__a)-1] # on enlève les ()
    __split = __a.split(",")
    __a_originale = A.expression_originale[A.t1+6:len(A.expression_originale)].strip() #à cause littéraux "MAjuscules"
    __a_originale = __a_originale[1:len(__a_originale)-1] # on enlève les ()
    __split_originale = __a_originale.split(",")
    __valeurs = " ("
    for __i in range(0,len(__split)): # on récupère les différentes valeurs de variables
        __a = __split[__i].strip()
        __a_originale = __split_originale[__i].strip()
        __b = __a[0]
        if __b == ":": 
            __a = __a[1:len(__a)] # on enlève le :
            lit_valeur(__a)
            if A.erreur_grave: return None #requête erronée
            __valeurs += A.valeur + ","
        else:
            __valeurs += str(__a_originale) + ","
    __valeurs = __valeurs[0:len(__valeurs)-1] + ")"
    A.requete = A.expression[0:A.t1+7] + __valeurs
    try:
        A.db_curseur.execute(A.requete)
    except:
        A.pile_db_erreur_sql[A.db_num] = True
    return None

def sql_select():
    sql_select_valeurs()
    if A.erreur_grave: return None
    try:
        A.db_curseur.execute(A.requete)
    except:
        A.pile_db_erreur_sql[A.db_num] = True
    __resultats = A.db_curseur.fetchall()
    if len(__resultats) == 0:
        A.pile_db_erreur_sql[A.db_num] = True
        return None
    for __i in range(0,len(__resultats)):
        __a = str(__resultats[__i]) + "\n"
        affiche_texte(__a)

    return None

def sql_update():
    sql_select_valeurs()
    if A.erreur_grave: return None
    try:
        A.db_curseur.execute(A.requete)
    except:
        A.pile_db_erreur_sql[A.db_num] = True
    return None

def sql_delete():
    sql_select_valeurs()
    if A.erreur_grave: return None
    try:
        A.db_curseur.execute(A.requete)
    except:
        A.pile_db_erreur_sql[A.db_num] = True
    return None

def sql_select_valeurs():
    A.requete = ""
    A.expression_originale += " "
    __guillemet = False
    __i1 = -1
    for __i in range(0,len(A.expression_originale)):
        __i1 += 1
        if __i1 >= len(A.expression_originale): break
        __a = A.expression_originale[__i1]
        if __a == '"':
            A.requete += __a
            __guillemet = not __guillemet
            continue
        if __a != ":":
            A.requete += __a
            continue
        if __guillemet:
            A.requete += __a
            continue
        # : rencontré hors guillemet = une variable hôte
        A.ident = ""
        for __j in range(__i1+1,len(A.expression_originale)):
            __b = A.expression_originale[__j]
            if __b == " ": break
            A.ident += __b
        A.ident = A.ident.lower()
        lit_valeur(A.ident)
        if A.erreur_grave: return None
        A.requete += A.valeur
        __i1 = __j - 1
    return None

def sql_curseur_declare():
    # A.pile_db_cursor  A.pile_db_cursor_var ...
    __a = A.expression[15:len(A.expression)].strip()
    A.t1 = __a.find(" ")
    if A.t1 == -1:
        A.erreur_grave = True ; A.code_erreur = 1079 ; return None #requête erronée
    A.ident_curseur = __a[0:A.t1].strip() #ident du curseur
    if A.ident_curseur in A.pile_db_cursor_ident:
        A.erreur_grave = True ; A.code_erreur = 1079 ; return None #requête erronée curseur existe déjà
        return None
    __t1 = A.expression.find("select ")
    if __t1 == -1:
        A.erreur_grave = True ; A.code_erreur = 1079 ; return None #requête erronée select attendu
    __t2 = A.expression.find("from ",A.t1)
    if __t2 == -1:
        A.erreur_grave = True ; A.code_erreur = 1079 ; return None #requête erronée from attendu
    sql_select_valeurs()
    A.pile_db_cursor_ident.append(A.ident_curseur)
    A.pile_db_cursor_var.append(False) #le curseur n'est pas ouvert
    A.pile_db_cursor.append(A.db.cursor()) # objet cursor initialisé à l'ouverture (requête OPEN CURSOR)
    __a = A.requete[__t1:len(A.requete)]
    A.pile_db_cursor_requete.append(__a)
    __a = A.requete[__t1+7:__t2]
    __split = __a.split(",") #liste des variables (select var1,var2,...)
    for __i in range(0,len(__split)):
        __b = __split[__i].strip()
        A.pile_db_cursor_ident.append(A.ident_curseur)
        A.pile_db_cursor_var.append(__b)
        A.pile_db_cursor.append("")
        A.pile_db_cursor_requete.append("")
    if A.erreur_grave: return None
    return None

def sql_curseur_open():
    # A.pile_db_cursor  A.pile_db_cursor_var ...
    A.t1 = A.expression.find(" ")
    if A.t1 == -1:
        A.erreur_grave = True ; A.code_erreur = 1079 ; return None #requête erronée
    A.ident = A.expression[A.t1+1:len(A.expression)].strip() #ident du curseur
    if A.ident not in A.pile_db_cursor_ident:
        A.erreur_grave = True ; A.code_erreur = 1079 ; return None #requête erronée ; le curseur n'existe pas
        return None 
    A.i_cursor = A.pile_db_cursor_ident.index(A.ident)
    if A.pile_db_cursor_var[A.i_cursor]:
        A.erreur_grave = True ; A.code_erreur = 1079 ; return None #requête erronée ; le curseur est déjà ouvert
    A.pile_db_cursor_var[A.i_cursor] = True
    try:
        A.pile_db_cursor[A.i_cursor].execute(A.pile_db_cursor_requete[A.i_cursor])
    except:
        A.pile_db_erreur_sql[A.db_num] = True
    return None

def sql_curseur_fetch():
    # A.pile_db_cursor  A.pile_db_cursor_var ...
    A.t1 = A.expression.find(" ")
    if A.t1 == -1:
        A.erreur_grave = True ; A.code_erreur = 1079 ; return None #requête erronée
    A.ident = A.expression[A.t1+1:len(A.expression)].strip() #ident du curseur
    if A.ident not in A.pile_db_cursor_ident:
        A.erreur_grave = True ; A.code_erreur = 1079 ; return None #requête erronée ; le curseur n'existe pas
        return None 
    A.i_cursor = A.pile_db_cursor_ident.index(A.ident)
    if not A.pile_db_cursor_var[A.i_cursor]:
        A.erreur_grave = True ; A.code_erreur = 1079 ; return None #requête erronée ; le curseur n'est pas ouvert
    try:
        A.valeurs = A.pile_db_cursor[A.i_cursor].fetchone()
    except:
        A.pile_db_erreur_sql[A.db_num] = True
        return None
    if A.valeurs == None:
        A.pile_db_erreur_sql[A.db_num] = True
        return None
    for __i in range(0,len(A.valeurs)):
        A.i_cursor += 1
        A.ident = A.pile_db_cursor_var[A.i_cursor]
        A.valeur = A.valeurs[__i]
        if A.ident not in A.t_ident:
            A.erreur_grave = True ; A.code_erreur = 1079 ; return None #requête erronée ; variable n'existe pas
        A.ident_i = A.t_ident.index(A.ident)
        A.t_ident_valeur[A.ident_i] = A.valeur
    return None

def sql_curseur_close():
    # A.pile_db_cursor  A.pile_db_cursor_var

    return None

def affiche_texte(__texte):
    A.ScrolledText_ecran_exec.config(state=tk.NORMAL)
    A.pos_ecran = str(A.ScrolledText_ecran_exec.index(tk.INSERT))
    A.ScrolledText_ecran_exec.config(state=tk.DISABLED)
    A.t1 = A.pos_ecran.find(".")
    A.col_ecran = int(A.pos_ecran[A.t1+1:len(A.pos_ecran)])
    E.affiche_texte_ecrire_ecran(__texte)

def lit_valeur(__ident):
    A.erreur_grave = False
    if __ident not in A.t_ident:
        A.erreur_grave = True ; A.code_erreur = 1079 ; return None #requête erronée
    A.ident_i = A.t_ident.index(__ident)
    A.valeur = A.t_ident_valeur[A.ident_i]
    A.type = A.t_ident_type[A.ident_i]
    if A.type == 1 or A.type == 2:
        if A.t_ident_chaine_long[A.ident_i] != 0:
            __n = A.t_ident_chaine_long[A.ident_i] - len(A.valeur)
            A.valeur += E.ajoute_caracteres(32,__n)
        A.valeur = '"' + A.valeur + '"'
    else:
        A.valeur = str(A.valeur)
    return